//POLYMORPHISM
//============

/*Polymorphism can be expressed in code using interfaces.
  An interface in code terms is like a ready-to-use
  template that is deliberately lightweight to be easily
  reused and customised.*/

/* Definition of an interface:
 A "collection of empty (and
 therefore customisable) ready
 to use (and re-use) methods". */ 

function IVehicle(){

IVehicle.prototype.Start = function(){

}

IVehicle.prototype.Stop = function(){

}

IVehicle.prototype.CarryPassenger = function(){

}

IVehicle.prototype.Refuel = function(){

}

IVehicle.prototype.Accelerate = function(){

}

IVehicle.prototype.Decelerate = function(){

}
}

/*As examples, the objects bike and plane
demonstrate how any object based on IVehicle
can use the methods of the interface and
customise those methods to their own needs.*/

//Bike's version of the Start method
let bike = new IVehicle();
bike.Start = function(){
console.log("Start pedalling");
}
//bike.Start();

//Plane's version of the Start method
let plane = new IVehicle();
plane.Start = function(){
console.log("Start moving down runway");
}
//plane.Start();

//Bike's version of the CarryPassenger method
bike.CarryPassenger = function(){
console.log("Passenger on bike");
}
//bike.CarryPassenger();

//Plane's version of the CarryPassenger method
plane.CarryPassenger = function(){
console.log("Passenger on plane");
}
//plane.CarryPassenger();

class Plane {
	
	Plane = function takeoff(){
		
	}
	
	Plane = function fly(){
		
	}
	
	Plane = function land(){
		
	}
	
}

let fighterjet = new Plane();
fighterjet.takoff('Taking off...'); 
