"""
When entering an IP from the list after the text 'here:',
don't leave any space after the colon or the program will
fail to do the search.
"""

import pandas as pd

# Read in data from csv doc
data = pd.read_csv("data/ip_list_2.csv")
print(data)

# Convert DataFrame to dictionary
to_dictionary = pd.DataFrame.to_dict(data[['ip', 'city', 'country']])

# Query dictionary,
def get_data_from_ip():
    print('Please enter your IP')
    my_ip = input('here:')
    print(data[data['ip'].str.match(my_ip)])

if data.empty:
   print('IP is not contained in the list')

get_data_from_ip()  
